/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import io.wispforest.accessories.api.components.AccessoryStackSizeComponent;
import io.wispforest.accessories.api.data.AccessoriesBaseData;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import io.wispforest.accessories.api.events.CanEquipCallback;
import io.wispforest.accessories.api.events.CanUnequipCallback;
import io.wispforest.accessories.api.slot.EntityBasedPredicate;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.AccessoryBreak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesAPI {
    private static final Logger LOGGER = LogUtils.getLogger();
    @ApiStatus.Internal
    public static final Accessory DEFAULT = new Accessory(){

        @Override
        public int maxStackSize(class_1799 stack) {
            AccessoryStackSizeComponent data = (AccessoryStackSizeComponent)stack.method_57825(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT);
            if (data.useStackSize()) {
                return stack.method_7914();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.method_7914());
        }
    };
    @ApiStatus.Internal
    private static final AccessoryNest DEFAULT_NEST = new AccessoryNest(){

        @Override
        public int maxStackSize(class_1799 stack) {
            AccessoryStackSizeComponent data = (AccessoryStackSizeComponent)stack.method_57825(AccessoriesDataComponents.STACK_SIZE, (Object)AccessoryStackSizeComponent.DEFAULT);
            if (data.useStackSize()) {
                return stack.method_7914();
            }
            return Math.min(Math.max(data.sizeOverride(), 1), stack.method_7914());
        }
    };
    private static final Map<class_2960, SlotBasedPredicate> PREDICATE_REGISTRY = new HashMap<class_2960, SlotBasedPredicate>();
    private static final Map<class_1792, Accessory> REGISTER = new HashMap<class_1792, Accessory>();
    @Deprecated(forRemoval=true)
    public static final class_6862<class_1792> ALL_ACCESSORIES = AccessoriesTags.ALL_TAG;
    @Deprecated(forRemoval=true)
    public static final class_6862<class_1792> ANY_ACCESSORIES = AccessoriesTags.ANY_TAG;

    @ApiStatus.Internal
    public static Map<class_1792, Accessory> getAllAccessories() {
        return Collections.unmodifiableMap(REGISTER);
    }

    public static void registerAccessory(class_1792 item, Accessory accessory) {
        REGISTER.put(item, accessory);
    }

    @Nullable
    public static Accessory getAccessory(class_1799 stack) {
        return AccessoriesAPI.getAccessory(stack.method_7909());
    }

    @Nullable
    public static Accessory getAccessory(class_1792 item) {
        return REGISTER.get(item);
    }

    public static Accessory getOrDefaultAccessory(class_1799 stack) {
        Accessory accessory = REGISTER.get(stack.method_7909());
        if (accessory == null) {
            accessory = stack.method_57826(AccessoriesDataComponents.NESTED_ACCESSORIES) ? DEFAULT_NEST : DEFAULT;
        }
        return accessory;
    }

    public static Accessory getOrDefaultAccessory(class_1792 item) {
        return REGISTER.getOrDefault(item, DEFAULT);
    }

    public static Accessory defaultAccessory() {
        return DEFAULT;
    }

    public static boolean isDefaultAccessory(Accessory accessory) {
        return accessory == DEFAULT || accessory == DEFAULT_NEST;
    }

    public static boolean isValidAccessory(class_1799 stack, class_1937 level) {
        return AccessoriesAPI.isValidAccessory(stack, level, null);
    }

    public static boolean isValidAccessory(class_1799 stack, class_1937 level, @Nullable class_1309 entity) {
        return !AccessoriesAPI.isDefaultAccessory(AccessoriesAPI.getOrDefaultAccessory(stack)) || !AccessoriesAPI.getStackSlotTypes(level, entity, stack).isEmpty();
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, SlotReference slotReference) {
        return AccessoriesAPI.getAttributeModifiers(stack, slotReference, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, SlotReference slotReference, boolean useTooltipCheck) {
        return AccessoriesAPI.getAttributeModifiers(stack, slotReference.entity(), slotReference.slotName(), slotReference.slot(), useTooltipCheck);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, String slotName, int slot) {
        return AccessoriesAPI.getAttributeModifiers(stack, null, slotName, slot);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, @Nullable class_1309 entity, String slotName, int slot) {
        return AccessoriesAPI.getAttributeModifiers(stack, entity, slotName, slot, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(class_1799 stack, @Nullable class_1309 entity, String slotName, int slot, boolean hideTooltipIfDisabled) {
        SlotReference slotReference = SlotReference.of(entity, slotName, slot);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        AccessoryNestUtils.recursiveStackConsumption(stack, slotReference, (innerStack, innerRef) -> {
            AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)innerStack.method_57825(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
            AccessoryAttributeBuilder innerBuilder = !hideTooltipIfDisabled || component.showInTooltip() ? component.gatherAttributes((SlotReference)innerRef) : new AccessoryAttributeBuilder(slotName, slot);
            builder.addFrom(innerBuilder);
        });
        if (entity != null) {
            Accessory accessory = AccessoriesAPI.getAccessory(stack);
            if (accessory != null) {
                accessory.getDynamicModifiers(stack, slotReference, builder);
            }
            ((AdjustAttributeModifierCallback)AdjustAttributeModifierCallback.EVENT.invoker()).adjustAttributes(stack, slotReference, builder);
        }
        return builder;
    }

    public static void addAttribute(class_1799 stack, String slotName, class_6880<class_1320> attribute, class_2960 location, double amount, class_1322.class_1323 operation, boolean isStackable) {
        stack.method_57368(AccessoriesDataComponents.ATTRIBUTES, (Object)new AccessoryItemAttributeModifiers(List.of(), true), modifiers -> modifiers.withModifierAdded(attribute, new class_1322(location, amount, operation), slotName, isStackable));
    }

    public static class_2960 createSlotLocation(SlotType slotType, int index) {
        return AccessoriesAPI.createSlotLocation(slotType.name(), index);
    }

    public static class_2960 createSlotLocation(String slotName, int index) {
        return Accessories.of(slotName.replace(":", "_") + "/" + index);
    }

    public static boolean canInsertIntoSlot(class_1799 stack, SlotReference reference) {
        SlotType slotType = reference.type();
        if (slotType == null) {
            throw new IllegalStateException("Unable to get the needed SlotType from the SlotReference passed within `canInsertIntoSlot`! [Name: " + reference.slotName() + "]");
        }
        return AccessoriesAPI.getPredicateResults(slotType.validators(), reference.entity().method_37908(), reference.entity(), slotType, 0, stack) && AccessoriesAPI.canEquip(stack, reference);
    }

    public static boolean canEquip(class_1799 stack, SlotReference reference) {
        TriState result = ((CanEquipCallback)CanEquipCallback.EVENT.invoker()).canEquip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoriesAPI.getOrDefaultAccessory(stack).canEquip(stack, reference);
    }

    public static boolean canUnequip(class_1799 stack, SlotReference reference) {
        TriState result = ((CanUnequipCallback)CanUnequipCallback.EVENT.invoker()).canUnequip(stack, reference);
        if (!result.equals((Object)TriState.DEFAULT)) {
            return result.orElse(true);
        }
        return AccessoriesAPI.getOrDefaultAccessory(stack).canUnequip(stack, reference);
    }

    public static Collection<SlotType> getValidSlotTypes(class_1309 entity, class_1799 stack) {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots(entity);
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            Map<String, AccessoriesContainer> containers = capability.getContainers();
            block0: for (SlotType value : slots.values()) {
                if (!containers.containsKey(value.name())) continue;
                AccessoriesContainer container = containers.get(value.name());
                int size = containers.get(value.name()).getSize();
                if (size == 0) {
                    size = 1;
                }
                for (int i = 0; i < size; ++i) {
                    SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                    if (!AccessoriesAPI.canInsertIntoSlot(stack, reference)) continue;
                    validSlots.add(value);
                    continue block0;
                }
            }
        }
        return validSlots;
    }

    public static Collection<SlotType> getStackSlotTypes(class_1937 level, class_1799 stack) {
        return AccessoriesAPI.getStackSlotTypes(level, null, stack);
    }

    public static Collection<SlotType> getStackSlotTypes(class_1309 entity, class_1799 stack) {
        return AccessoriesAPI.getStackSlotTypes(entity.method_37908(), entity, stack);
    }

    public static Collection<SlotType> getStackSlotTypes(class_1937 level, @Nullable class_1309 entity, class_1799 stack) {
        ArrayList<SlotType> validSlots = new ArrayList<SlotType>();
        for (SlotType value : SlotTypeLoader.getSlotTypes(level).values()) {
            if (!AccessoriesAPI.getPredicateResults(value.validators(), level, entity, value, 0, stack)) continue;
            validSlots.add(value);
        }
        return validSlots;
    }

    public static Collection<SlotType> getUsedSlotsFor(class_1657 player) {
        return AccessoriesAPI.getUsedSlotsFor((class_1309)player, (class_1263)player.method_31548());
    }

    public static Collection<SlotType> getUsedSlotsFor(class_1309 entity, class_1263 container) {
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability == null) {
            return Set.of();
        }
        HashSet<SlotType> slots = new HashSet<SlotType>();
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            slots.addAll(AccessoriesAPI.getValidSlotTypes(entity, stack));
        }
        for (SlotEntryReference ref : capability.getAllEquipped()) {
            slots.addAll(AccessoriesAPI.getValidSlotTypes(entity, ref.stack()));
        }
        slots.addAll(SlotTypeLoader.getUsedSlotsByRegistryItem(entity));
        return slots;
    }

    public static void breakStack(SlotReference reference) {
        AccessoriesNetworking.sendToTrackingAndSelf((class_1297)reference.entity(), AccessoryBreak.of(reference));
    }

    @Nullable
    public static SlotBasedPredicate getPredicate(class_2960 location) {
        return PREDICATE_REGISTRY.get(location);
    }

    public static void registerPredicate(class_2960 location, SlotBasedPredicate predicate) {
        if (PREDICATE_REGISTRY.containsKey(location)) {
            LOGGER.warn("[AccessoriesAPI]: A SlotBasedPredicate attempted to be registered but a duplicate entry existed already! [Id: {}]", (Object)location);
            return;
        }
        PREDICATE_REGISTRY.put(location, predicate);
    }

    public static boolean getPredicateResults(Set<class_2960> predicateIds, class_1937 level, SlotType slotType, int index, class_1799 stack) {
        return AccessoriesAPI.getPredicateResults(predicateIds, level, null, slotType, index, stack);
    }

    public static boolean getPredicateResults(Set<class_2960> predicateIds, class_1937 level, @Nullable class_1309 entity, SlotType slotType, int index, class_1799 stack) {
        TriState result = TriState.DEFAULT;
        for (class_2960 predicateId : predicateIds) {
            SlotBasedPredicate predicate = AccessoriesAPI.getPredicate(predicateId);
            if (predicate == null) continue;
            if (predicate instanceof EntityBasedPredicate) {
                EntityBasedPredicate entityBasedPredicate = (EntityBasedPredicate)predicate;
                result = entityBasedPredicate.isValid(level, entity, slotType, index, stack);
            } else {
                result = predicate.isValid(level, slotType, index, stack);
            }
            if (result == TriState.DEFAULT) continue;
            break;
        }
        return result.orElse(false);
    }

    public static class_6862<class_1792> getSlotTag(SlotType slotType) {
        class_2960 location = UniqueSlotHandling.isUniqueSlot(slotType.name()) ? class_2960.method_60654((String)slotType.name()) : Accessories.of(slotType.name());
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)location);
    }

    static {
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.ALL_PREDICATE_ID, (level, slotType, i, stack) -> TriState.TRUE);
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.NONE_PREDICATE_ID, (level, slotType, i, stack) -> TriState.FALSE);
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.TAG_PREDICATE_ID, (level, slotType, i, stack) -> stack.method_31573(AccessoriesAPI.getSlotTag(slotType)) || stack.method_31573(AccessoriesTags.ANY_TAG) ? TriState.TRUE : TriState.DEFAULT);
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.RELEVANT_PREDICATE_ID, (level, slotType, i, stack) -> {
            boolean bl = !AccessoriesAPI.getAttributeModifiers(stack, null, slotType.name(), i).getAttributeModifiers(false).isEmpty();
            return bl ? TriState.TRUE : TriState.DEFAULT;
        });
        AccessoriesAPI.registerPredicate(AccessoriesBaseData.COMPONENT_PREDICATE_ID, (level, slotType, index, stack) -> {
            if (stack.method_57826(AccessoriesDataComponents.SLOT_VALIDATION)) {
                AccessorySlotValidationComponent slotValidationData = (AccessorySlotValidationComponent)stack.method_57824(AccessoriesDataComponents.SLOT_VALIDATION);
                String name = slotType.name();
                Set<String> invalidSlots = slotValidationData.invalidSlotOverrides();
                for (String invalidSlot : invalidSlots) {
                    if (!name.equals(invalidSlot)) continue;
                    return TriState.FALSE;
                }
                Set<String> validSlots = slotValidationData.validSlotOverrides();
                for (String validSlot : validSlots) {
                    if (validSlot.equals("any")) {
                        return TriState.TRUE;
                    }
                    if (!name.equals(validSlot)) continue;
                    return TriState.TRUE;
                }
            }
            return TriState.DEFAULT;
        });
    }
}

